/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.interceptor;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.HttpChecksumConstant;
import software.amazon.awssdk.core.checksums.Algorithm;
import software.amazon.awssdk.core.checksums.ChecksumSpecs;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.internal.util.HttpChecksumResolver;
import software.amazon.awssdk.core.internal.util.HttpChecksumUtils;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.utils.BinaryUtils;

@SdkInternalApi
public class HttpChecksumInHeaderInterceptor
implements ExecutionInterceptor {
    @Override
    public void afterMarshalling(Context.AfterMarshalling context, ExecutionAttributes executionAttributes) {
        ChecksumSpecs headerChecksumSpecs = HttpChecksumUtils.checksumSpecWithRequestAlgorithm(executionAttributes).orElse(null);
        if (this.shouldSkipHttpChecksumInHeader(context, executionAttributes, headerChecksumSpecs)) {
            return;
        }
        Optional<RequestBody> syncContent = context.requestBody();
        syncContent.ifPresent(requestBody -> HttpChecksumInHeaderInterceptor.saveContentChecksum(requestBody, executionAttributes, headerChecksumSpecs.algorithm()));
    }

    @Override
    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        ChecksumSpecs checksumSpecs = HttpChecksumResolver.getResolvedChecksumSpecs(executionAttributes);
        if (this.shouldSkipHttpChecksumInHeader(context, executionAttributes, checksumSpecs)) {
            return context.httpRequest();
        }
        String httpChecksumValue = executionAttributes.getAttribute(HttpChecksumConstant.HTTP_CHECKSUM_VALUE);
        if (httpChecksumValue != null) {
            return (SdkHttpRequest)context.httpRequest().copy(r -> r.putHeader(checksumSpecs.headerName(), httpChecksumValue));
        }
        return context.httpRequest();
    }

    private static void saveContentChecksum(RequestBody requestBody, ExecutionAttributes executionAttributes, Algorithm algorithm) {
        try {
            String payloadChecksum = BinaryUtils.toBase64((byte[])HttpChecksumUtils.computeChecksum(requestBody.contentStreamProvider().newStream(), algorithm));
            executionAttributes.putAttribute(HttpChecksumConstant.HTTP_CHECKSUM_VALUE, payloadChecksum);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean shouldSkipHttpChecksumInHeader(Context.AfterMarshalling context, ExecutionAttributes executionAttributes, ChecksumSpecs headerChecksumSpecs) {
        return headerChecksumSpecs == null || headerChecksumSpecs.algorithm() == null || HttpChecksumUtils.isHttpChecksumPresent(context.httpRequest(), headerChecksumSpecs) || !HttpChecksumUtils.isUnsignedPayload(executionAttributes.getAttribute(HttpChecksumConstant.SIGNING_METHOD), context.httpRequest().protocol(), context.requestBody().map(requestBody -> requestBody.contentStreamProvider() != null).orElse(false)) || headerChecksumSpecs.isRequestStreaming();
    }
}

