/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.http.pipeline.stages;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.http.ExecutionContext;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.InterceptorContext;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.core.internal.http.HttpClientDependencies;
import software.amazon.awssdk.core.internal.http.RequestExecutionContext;
import software.amazon.awssdk.core.internal.http.pipeline.RequestPipeline;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.signer.AsyncRequestBodySigner;
import software.amazon.awssdk.core.signer.AsyncSigner;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.metrics.MetricCollector;

@SdkInternalApi
public class AsyncSigningStage
implements RequestPipeline<SdkHttpFullRequest, CompletableFuture<SdkHttpFullRequest>> {
    private final HttpClientDependencies dependencies;

    public AsyncSigningStage(HttpClientDependencies dependencies) {
        this.dependencies = dependencies;
    }

    @Override
    public CompletableFuture<SdkHttpFullRequest> execute(SdkHttpFullRequest request, RequestExecutionContext context) throws Exception {
        return this.signRequest(request, context);
    }

    private CompletableFuture<SdkHttpFullRequest> signRequest(SdkHttpFullRequest request, RequestExecutionContext context) {
        this.updateInterceptorContext(request, context.executionContext());
        Signer signer = context.signer();
        MetricCollector metricCollector = context.attemptMetricCollector();
        if (!this.shouldSign(signer)) {
            return CompletableFuture.completedFuture(request);
        }
        this.adjustForClockSkew(context.executionAttributes());
        AsyncSigner asyncSigner = this.asAsyncSigner(signer, context);
        long signingStart = System.nanoTime();
        CompletableFuture<SdkHttpFullRequest> signedRequestFuture = asyncSigner.sign(request, context.requestProvider(), context.executionAttributes());
        signedRequestFuture.whenComplete((r, t) -> metricCollector.reportMetric(CoreMetric.SIGNING_DURATION, (Object)Duration.ofNanos(System.nanoTime() - signingStart)));
        return signedRequestFuture.thenApply(r -> {
            this.updateInterceptorContext((SdkHttpFullRequest)r, context.executionContext());
            return r;
        });
    }

    private void updateInterceptorContext(SdkHttpFullRequest request, ExecutionContext executionContext) {
        executionContext.interceptorContext((InterceptorContext)executionContext.interceptorContext().copy(b -> b.httpRequest((SdkHttpRequest)request)));
    }

    private boolean shouldSign(Signer signer) {
        return signer != null;
    }

    private void adjustForClockSkew(ExecutionAttributes attributes) {
        attributes.putAttribute(SdkExecutionAttribute.TIME_OFFSET, this.dependencies.timeOffset());
    }

    private AsyncSigner asAsyncSigner(Signer signer, RequestExecutionContext context) {
        if (signer instanceof AsyncSigner) {
            return (AsyncSigner)((Object)signer);
        }
        return (request, requestBody, executionAttributes) -> {
            SdkHttpFullRequest signedRequest = signer.sign(request, executionAttributes);
            if (signer instanceof AsyncRequestBodySigner) {
                AsyncRequestBody transformedRequestProvider = ((AsyncRequestBodySigner)((Object)signer)).signAsyncRequestBody(signedRequest, context.requestProvider(), context.executionAttributes());
                context.requestProvider(transformedRequestProvider);
            }
            return CompletableFuture.completedFuture(signedRequest);
        };
    }
}

