/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.Serializable;
import java.util.Locale;
import javax.servlet.http.CookieNameValidator;
import javax.servlet.http.NetscapeValidator;
import javax.servlet.http.RFC2109Validator;

public class Cookie
implements Cloneable,
Serializable {
    private static final CookieNameValidator validation;
    private static final long serialVersionUID = 1L;
    private final String name;
    private String value;
    private int version = 0;
    private String comment;
    private String domain;
    private int maxAge = -1;
    private String path;
    private boolean secure;
    private boolean httpOnly;

    public Cookie(String string, String string2) {
        validation.validate(string);
        this.name = string;
        this.value = string2;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }

    public void setDomain(String string) {
        this.domain = string.toLowerCase(Locale.ENGLISH);
    }

    public String getDomain() {
        return this.domain;
    }

    public void setMaxAge(int n) {
        this.maxAge = n;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public String getPath() {
        return this.path;
    }

    public void setSecure(boolean bl) {
        this.secure = bl;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getValue() {
        return this.value;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public void setHttpOnly(boolean bl) {
        this.httpOnly = bl;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    static {
        String string = System.getProperty("org.apache.tomcat.util.http.ServerCookie.STRICT_NAMING");
        boolean bl = string != null ? Boolean.parseBoolean(string) : Boolean.getBoolean("org.apache.catalina.STRICT_SERVLET_COMPLIANCE");
        validation = bl ? new RFC2109Validator() : new NetscapeValidator();
    }
}

