/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.streams;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.awscore.client.builder.AwsDefaultClientBuilder;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.interceptor.ClasspathInterceptorChainFactory;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsBaseClientBuilder;
import software.amazon.awssdk.utils.CollectionUtils;

@SdkInternalApi
abstract class DefaultDynamoDbStreamsBaseClientBuilder<B extends DynamoDbStreamsBaseClientBuilder<B, C>, C>
extends AwsDefaultClientBuilder<B, C> {
    DefaultDynamoDbStreamsBaseClientBuilder() {
    }

    protected final String serviceEndpointPrefix() {
        return "streams.dynamodb";
    }

    protected final String serviceName() {
        return "DynamoDbStreams";
    }

    protected final SdkClientConfiguration mergeServiceDefaults(SdkClientConfiguration config) {
        return config.merge(c -> c.option((ClientOption)SdkAdvancedClientOption.SIGNER, (Object)this.defaultSigner()).option((ClientOption)SdkClientOption.CRC32_FROM_COMPRESSED_DATA_ENABLED, (Object)true));
    }

    protected final SdkClientConfiguration mergeInternalDefaults(SdkClientConfiguration config) {
        return config.merge(c -> {
            c.option((ClientOption)SdkClientOption.INTERNAL_USER_AGENT, (Object)"md/internal");
            c.option((ClientOption)SdkClientOption.DEFAULT_RETRY_MODE, (Object)RetryMode.STANDARD);
        });
    }

    protected final SdkClientConfiguration finalizeServiceConfiguration(SdkClientConfiguration config) {
        ClasspathInterceptorChainFactory interceptorFactory = new ClasspathInterceptorChainFactory();
        List interceptors = interceptorFactory.getInterceptors("software/amazon/awssdk/services/dynamodb/streams/execution.interceptors");
        interceptors = CollectionUtils.mergeLists((List)interceptors, (List)((List)config.option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS)));
        return config.toBuilder().option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS, (Object)interceptors).build();
    }

    private Signer defaultSigner() {
        return Aws4Signer.create();
    }

    protected final String signingName() {
        return "dynamodb";
    }
}

