/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.string;

import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.PrimitiveConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.StringConverter;

@SdkInternalApi
@ThreadSafe
@Immutable
public class BooleanStringConverter
implements StringConverter<Boolean>,
PrimitiveConverter<Boolean> {
    private BooleanStringConverter() {
    }

    public static BooleanStringConverter create() {
        return new BooleanStringConverter();
    }

    @Override
    public EnhancedType<Boolean> type() {
        return EnhancedType.of(Boolean.class);
    }

    @Override
    public EnhancedType<Boolean> primitiveType() {
        return EnhancedType.of(Boolean.TYPE);
    }

    @Override
    public Boolean fromString(String string) {
        switch (string) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
        }
        throw new IllegalArgumentException("Boolean string was not 'true' or 'false': " + string);
    }
}

