/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLongArray;

@GwtIncompatible
public class AtomicDoubleArray
implements Serializable {
    private static final long serialVersionUID = 0L;
    private transient AtomicLongArray longs;

    public AtomicDoubleArray(int n) {
        this.longs = new AtomicLongArray(n);
    }

    public AtomicDoubleArray(double[] dArray) {
        int n = dArray.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = Double.doubleToRawLongBits(dArray[i]);
        }
        this.longs = new AtomicLongArray(lArray);
    }

    public final int length() {
        return this.longs.length();
    }

    public final double get(int n) {
        return Double.longBitsToDouble(this.longs.get(n));
    }

    public final void set(int n, double d) {
        long l = Double.doubleToRawLongBits(d);
        this.longs.set(n, l);
    }

    public final void lazySet(int n, double d) {
        this.set(n, d);
    }

    public final double getAndSet(int n, double d) {
        long l = Double.doubleToRawLongBits(d);
        return Double.longBitsToDouble(this.longs.getAndSet(n, l));
    }

    public final boolean compareAndSet(int n, double d, double d2) {
        return this.longs.compareAndSet(n, Double.doubleToRawLongBits(d), Double.doubleToRawLongBits(d2));
    }

    public final boolean weakCompareAndSet(int n, double d, double d2) {
        return this.longs.weakCompareAndSet(n, Double.doubleToRawLongBits(d), Double.doubleToRawLongBits(d2));
    }

    @CanIgnoreReturnValue
    public final double getAndAdd(int n, double d) {
        double d2;
        double d3;
        long l;
        long l2;
        while (!this.longs.compareAndSet(n, l2 = this.longs.get(n), l = Double.doubleToRawLongBits(d3 = (d2 = Double.longBitsToDouble(l2)) + d))) {
        }
        return d2;
    }

    @CanIgnoreReturnValue
    public double addAndGet(int n, double d) {
        double d2;
        double d3;
        long l;
        long l2;
        while (!this.longs.compareAndSet(n, l2 = this.longs.get(n), l = Double.doubleToRawLongBits(d3 = (d2 = Double.longBitsToDouble(l2)) + d))) {
        }
        return d3;
    }

    public String toString() {
        int n = this.length() - 1;
        if (n == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(19 * (n + 1));
        stringBuilder.append('[');
        int n2 = 0;
        while (true) {
            stringBuilder.append(Double.longBitsToDouble(this.longs.get(n2)));
            if (n2 == n) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(',').append(' ');
            ++n2;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = this.length();
        objectOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            objectOutputStream.writeDouble(this.get(i));
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        if (n < 0) {
            throw new AssertionError((Object)("Invalid length " + n));
        }
        Builder builder = new Builder(n);
        for (int i = 0; i < n; ++i) {
            builder.add(Double.doubleToRawLongBits(objectInputStream.readDouble()));
        }
        this.longs = new AtomicLongArray(builder.toArray());
    }

    private static final class Builder {
        public static final int MAX_INITIAL_CAPACITY = 32;
        private long[] array;
        private final int limit;
        private int count = 0;

        Builder(int n) {
            this.array = new long[Math.min(n, 32)];
            this.limit = n;
        }

        public Builder add(long l) {
            this.ensureRoomFor(1);
            this.array[this.count] = l;
            ++this.count;
            return this;
        }

        private void ensureRoomFor(int n) {
            int n2 = this.count + n;
            if (n2 > this.limit) {
                throw new AssertionError((Object)("Attempt to store more elements than the given limit " + this.limit));
            }
            if (n2 > this.array.length) {
                this.array = Builder.resizeArray(this.array, this.count, this.expandedCapacity(this.array.length, n2));
            }
        }

        private static long[] resizeArray(long[] lArray, int n, int n2) {
            long[] lArray2 = new long[n2];
            System.arraycopy(lArray, 0, lArray2, 0, n);
            return lArray2;
        }

        private int expandedCapacity(int n, int n2) {
            if (n2 < 0) {
                throw new AssertionError((Object)"cannot store more than MAX_VALUE elements");
            }
            int n3 = n + (n >> 1) + 1;
            if (n3 < n2) {
                n3 = Integer.highestOneBit(n2 - 1) << 1;
            }
            if (n3 < 0) {
                n3 = Integer.MAX_VALUE;
            }
            if (n3 > this.limit) {
                n3 = this.limit;
            }
            return n3;
        }

        public long[] toArray() {
            if (this.count < this.array.length) {
                this.array = Builder.resizeArray(this.array, this.count, this.count);
            }
            return this.array;
        }
    }
}

