/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.UnmodifiableIterator;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

class MapIteratorCache<K, V> {
    private final Map<K, V> backingMap;
    @Nullable
    private transient Map.Entry<K, V> entrySetCache;

    MapIteratorCache(Map<K, V> map) {
        this.backingMap = Preconditions.checkNotNull(map);
    }

    @CanIgnoreReturnValue
    public V put(@Nullable K k, @Nullable V v) {
        this.clearCache();
        return this.backingMap.put(k, v);
    }

    @CanIgnoreReturnValue
    public V remove(@Nullable Object object) {
        this.clearCache();
        return this.backingMap.remove(object);
    }

    public void clear() {
        this.clearCache();
        this.backingMap.clear();
    }

    public V get(@Nullable Object object) {
        V v = this.getIfCached(object);
        return v != null ? v : this.getWithoutCaching(object);
    }

    public final V getWithoutCaching(@Nullable Object object) {
        return this.backingMap.get(object);
    }

    public final boolean containsKey(@Nullable Object object) {
        return this.getIfCached(object) != null || this.backingMap.containsKey(object);
    }

    public final Set<K> unmodifiableKeySet() {
        return new AbstractSet<K>(){

            @Override
            public UnmodifiableIterator<K> iterator() {
                final Iterator iterator = MapIteratorCache.this.backingMap.entrySet().iterator();
                return new UnmodifiableIterator<K>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public K next() {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        MapIteratorCache.this.entrySetCache = entry;
                        return entry.getKey();
                    }
                };
            }

            @Override
            public int size() {
                return MapIteratorCache.this.backingMap.size();
            }

            @Override
            public boolean contains(@Nullable Object object) {
                return MapIteratorCache.this.containsKey(object);
            }
        };
    }

    protected V getIfCached(@Nullable Object object) {
        Map.Entry<K, V> entry = this.entrySetCache;
        if (entry != null && entry.getKey() == object) {
            return entry.getValue();
        }
        return null;
    }

    protected void clearCache() {
        this.entrySetCache = null;
    }
}

