/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.graph.AbstractGraph;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import com.google.common.graph.Network;
import com.google.common.math.IntMath;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

@Beta
public abstract class AbstractNetwork<N, E>
implements Network<N, E> {
    @Override
    public Graph<N> asGraph() {
        return new AbstractGraph<N>(){

            @Override
            public Set<N> nodes() {
                return AbstractNetwork.this.nodes();
            }

            @Override
            public Set<EndpointPair<N>> edges() {
                if (AbstractNetwork.this.allowsParallelEdges()) {
                    return super.edges();
                }
                return new AbstractSet<EndpointPair<N>>(){

                    @Override
                    public Iterator<EndpointPair<N>> iterator() {
                        return Iterators.transform(AbstractNetwork.this.edges().iterator(), new Function<E, EndpointPair<N>>(){

                            @Override
                            public EndpointPair<N> apply(E e) {
                                return AbstractNetwork.this.incidentNodes(e);
                            }
                        });
                    }

                    @Override
                    public int size() {
                        return AbstractNetwork.this.edges().size();
                    }

                    @Override
                    public boolean contains(@Nullable Object object) {
                        if (!(object instanceof EndpointPair)) {
                            return false;
                        }
                        EndpointPair endpointPair = (EndpointPair)object;
                        return this.isDirected() == endpointPair.isOrdered() && this.nodes().contains(endpointPair.nodeU()) && this.successors(endpointPair.nodeU()).contains(endpointPair.nodeV());
                    }
                };
            }

            @Override
            public ElementOrder<N> nodeOrder() {
                return AbstractNetwork.this.nodeOrder();
            }

            @Override
            public boolean isDirected() {
                return AbstractNetwork.this.isDirected();
            }

            @Override
            public boolean allowsSelfLoops() {
                return AbstractNetwork.this.allowsSelfLoops();
            }

            @Override
            public Set<N> adjacentNodes(Object object) {
                return AbstractNetwork.this.adjacentNodes(object);
            }

            @Override
            public Set<N> predecessors(Object object) {
                return AbstractNetwork.this.predecessors(object);
            }

            @Override
            public Set<N> successors(Object object) {
                return AbstractNetwork.this.successors(object);
            }
        };
    }

    @Override
    public int degree(Object object) {
        if (this.isDirected()) {
            return IntMath.saturatedAdd(this.inEdges(object).size(), this.outEdges(object).size());
        }
        return IntMath.saturatedAdd(this.incidentEdges(object).size(), this.edgesConnecting(object, object).size());
    }

    @Override
    public int inDegree(Object object) {
        return this.isDirected() ? this.inEdges(object).size() : this.degree(object);
    }

    @Override
    public int outDegree(Object object) {
        return this.isDirected() ? this.outEdges(object).size() : this.degree(object);
    }

    @Override
    public Set<E> adjacentEdges(Object object) {
        EndpointPair endpointPair = this.incidentNodes(object);
        Sets.SetView setView = Sets.union(this.incidentEdges(endpointPair.nodeU()), this.incidentEdges(endpointPair.nodeV()));
        return Sets.difference(setView, ImmutableSet.of(object));
    }

    public String toString() {
        String string = String.format("isDirected: %s, allowsParallelEdges: %s, allowsSelfLoops: %s", this.isDirected(), this.allowsParallelEdges(), this.allowsSelfLoops());
        return String.format("%s, nodes: %s, edges: %s", string, this.nodes(), this.edgeIncidentNodesMap());
    }

    private Map<E, EndpointPair<N>> edgeIncidentNodesMap() {
        Function function = new Function<E, EndpointPair<N>>(){

            @Override
            public EndpointPair<N> apply(E e) {
                return AbstractNetwork.this.incidentNodes(e);
            }
        };
        return Maps.asMap(this.edges(), function);
    }
}

